proc tabulate data = ghpb21;
where filingsize in ('1','3');
class ent3 INS3 filingsize / PRELOADFMT;
title 'Table A4. Selected Income of Group Health Plans';
title2 'by type of insurance and type of plan, 2021';
title3 '(millions)';
title4 'All Plans with Trusts';
var tot_contrib_AME emplr_contrib_income_AME participant_contrib_AME oth_contrib_rcvd_AME NON_CASH_CONTRIB_BS_AME
tot_distrib_bnft_AME distrib_drt_partcp_AME ins_carrier_bnfts_AME oth_bnft_payment_AME ioh_ben
tot_admin_expenses_AME professional_fees_AME contract_admin_fees_AME invst_mgmt_fees_AME other_admin_fees_AME
tot_investment_income_AME;
table (tot_contrib_AME='CONTRIBUTIONS'
emplr_contrib_income_AME='Employer Contributions'
participant_contrib_AME='Participant Contributions'
oth_contrib_rcvd_AME='Contributions from Others (Including Rollovers)'
NON_CASH_CONTRIB_BS_AME='Noncash Contributions'
tot_investment_income_AME='INVESTMENT INCOME')*sum=' '*f=m12f_2stars., 
(all='All Plans' INS3=' ')*(all='Total' ent3=' ')/ Box='Selected Income' MISSTEXT='-';
run;

proc tabulate data = ghpb21;
WHERE FILINGSIZE='1';
class ent3 INS3 filingsize / PRELOADFMT;
title 'Table A4. Selected Income of Group Health Plans';
title2 'by type of insurance and type of plan, 2021';
title3 '(millions)';
title4 'Plans with 100 or More Participants and Trusts';
var tot_contrib_AME emplr_contrib_income_AME participant_contrib_AME oth_contrib_rcvd_AME NON_CASH_CONTRIB_BS_AME
tot_distrib_bnft_AME distrib_drt_partcp_AME ins_carrier_bnfts_AME oth_bnft_payment_AME ioh_ben
tot_admin_expenses_AME professional_fees_AME contract_admin_fees_AME invst_mgmt_fees_AME other_admin_fees_AME
tot_investment_income_AME;
table (tot_contrib_AME='CONTRIBUTIONS'
emplr_contrib_income_AME='Employer Contributions'
participant_contrib_AME='Participant Contributions'
oth_contrib_rcvd_AME='Contributions from Others (Including Rollovers)'
NON_CASH_CONTRIB_BS_AME='Noncash Contributions'
tot_investment_income_AME='INVESTMENT INCOME')*sum=' '*f=m12f_2stars., 
(all='All Plans' INS3=' ')*(all='Total' ent3=' ')/ Box='Selected Income' MISSTEXT='-';
run;

proc tabulate data = ghpb21;
WHERE FILINGSIZE='3';
class ent3 INS3 filingsize / PRELOADFMT;
title 'Table A4. Selected Income of Group Health Plans';
title2 'by type of insurance and type of plan, 2021';
title3 '(millions)';
title4 'Plans with Fewer Than 100 Participants and Trusts';
var tot_contrib_AME emplr_contrib_income_AME participant_contrib_AME oth_contrib_rcvd_AME NON_CASH_CONTRIB_BS_AME
tot_distrib_bnft_AME distrib_drt_partcp_AME ins_carrier_bnfts_AME oth_bnft_payment_AME ioh_ben
tot_admin_expenses_AME professional_fees_AME contract_admin_fees_AME invst_mgmt_fees_AME other_admin_fees_AME
tot_investment_income_AME;
table (tot_contrib_AME='CONTRIBUTIONS'
emplr_contrib_income_AME='Employer Contributions'
participant_contrib_AME='Participant Contributions'
oth_contrib_rcvd_AME='Contributions from Others (Including Rollovers)'
NON_CASH_CONTRIB_BS_AME='Noncash Contributions'
tot_investment_income_AME='INVESTMENT INCOME')*sum=' '*f=m12f_2stars., 
(all='All Plans' INS3=' ')*(all='Total' ent3=' ')/ Box='Selected Income' MISSTEXT='-';
run;
